#/*******************************************************************
# * This file is part of the Emulex Linux Device Driver for         *
# * Fibre Channel Host Bus Adapters.                                *
# * Copyright (C) 2003-2005 Emulex.  All rights reserved.           *
# * EMULEX and SLI are trademarks of Emulex.                        *
# * www.emulex.com                                                  *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of version 2 of the GNU General       *
# * Public License as published by the Free Software Foundation.    *
# * This program is distributed in the hope that it will be useful. *
# * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
# * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
# * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
# * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
# * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
# * more details, a copy of which can be found in the file COPYING  *
# * included with this package.                                     *
# *******************************************************************/
# This Makefile builds the lpfcdfc module for 2.4 Linux kernels.
######################################################################

# $Id: Makefile-2.4.mk 2757 2005-12-09 18:21:44Z sf_support $

ifeq (,$(KERNELVERSION))
   KERNELVERSION := $(shell uname -r)
endif

ifeq (,$(BASEINCLUDE))
   BASEINCLUDE := /lib/modules/$(KERNELVERSION)/build
endif

ifeq ($(shell uname -m),ppc64)
ifndef ($(CROSS_COMPILE))
CROSS_COMPILE := $(shell if [ -e /usr/local/ppc64-current3.0/bin/powerpc64-linux-gcc ]; then \
    echo /usr/local/ppc64-current3.0/bin/powerpc64-linux-; \
    else if [ -e /opt/cross/bin/powerpc64-linux-gcc ]; then \
    echo /opt/cross/bin/powerpc64-linux- ; fi fi)
endif
endif

lpfcdfc-objs := lpfc_cdev.o lpfc_util_ioctl.o lpfc_hbaapi_ioctl.o lpfc_debug_ioctl.o lpfc_misc.o

ifeq ($(CONFIG_SCSI_LPFC_IOCTLS),)
 CFLAGS := $(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(CFLAGS)")
 ARCH := $(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(ARCH)")
 MODFLAGS := $(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(MODFLAGS)")
 CC := $(CROSS_COMPILE)$(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(CC)")
 MODLIB := $(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(MODLIB)")
 LD := $(CROSS_COMPILE)$(shell make -C $(BASEINCLUDE) -s script "SCRIPT=echo \$$(LD)")

build: lpfcdfc.o

%.o : %.c
	$(CC) $(CFLAGS) $(EXTRA_CFLAGS) $(MODFLAGS) -c $<

install:
	@install -d $(MODLIB)/kernel/drivers/scsi;
	@install -c lpfcdfc.o $(MODLIB)/kernel/drivers/scsi;
	depmod -a
endif

EXTRA_CFLAGS +=  -I. -I..
EXTRA_CFLAGS += $(MODFLAGS)
EXTRA_CFLAGS += -DUSE_SCHEDULER

ifneq ($(CONFIG_SCSI_LPFC_IOCTLS),)
 EXTRA_CFLAGS += -I..
else
 EXTRA_CFLAGS += -I$(BASEINCLUDE)/drivers/scsi
endif

ifneq ($(CONFIG_SCSI_LPFC_IOCTLS),)
 obj-$(CONFIG_SCSI_LPFC_IOCTLS) += lpfcdfc.o
 MOD_DESTDIR = $(shell cd .. && $(CONFIG_SHELL) $(TOPDIR)/scripts/pathdown.sh)
 include $(TOPDIR)/Rules.make
endif

lpfcdfc.o: $(lpfcdfc-objs)
	$(LD) -r -o $@ $(lpfcdfc-objs)

clean:
	rm -f *.o
